
#ifndef CRYS_SST_TST_ATP_SYM_H
#define CRYS_SST_TST_ATP_SYM_H

#if TST_USE_CRYS_SST_SYM_MODULE

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 28 12:06:34 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_SST_TST_ATP_Sym.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************************ Defines *******************************/
/************************ Enums *********************************/
/************************ Typedefs  *****************************/
/************************ Structs  ******************************/
/*Authenticator test struct*/

/************************ Public Variables **********************/
/************************ Public Functions **********************/
/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_SST_TST_ATP_AES
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:
 *    Test the connection between CRYS and the SSTfunctionality while using SST AES generated keys
 *    in the CRYS_SST module
 *  
 * Algorithm:       
 *    1.    Create a new session by calling: SST_SessionCreate.
 *    2.    Open a transaction by calling: SST_TransactionStart.
 *    3.    Generate AES keys inside the SST by calling: CRYS_SST_KG_AES.
 *    4.    Read the Key from the SST by calling: SST_AESKeyRead.
 *    5.    Encrypt the data using CRYS and extracted data(key) by calling = CRYS_AES.
 *    6.    Decrypt the data using CRYS_SST by calling: CRYS_SST_AES.
 *    7.    Compare the decrypted result to the original
 *    8.  Delete the AES key by calling: SST_DataDelete.
 *    9.  Close the authenticator by calling: SST_AuthenticationClose.
 *    10.  Delete the authenticator by calling: SST_AuthenticatorDelete.
 *    11.  Close the transaction by calling: SST_TransactionClose.
 *    12.  Delete the session by calling: SST_SessionDelete.
 *                                
 *******************************************************************************/ 
DxError_t CRYS_SST_TST_ATP_AES ( void );

/*****************************************************************************
* Function Name:                                                           
*  CRYS_SST_TST_ATP_DES
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return                                        
*
* Description:                                                                 
*    Test the connection between CRYS and the SSTfunctionality while using SST DES generated keys
*    in the CRYS_SST module
*
* Algorithm:       
*    1.    Create a new session by calling: SST_SessionCreate.
*    2.    Open a transaction by calling: SST_TransactionStart.
*    3.    Generate AES keys inside the SST by calling: CRYS_SST_KG_DES.
*    4.    Read the Key from the SST by calling: SST_DESKeyRead.
*    5.    Encrypt the data using CRYS and extracted data(key) by calling = CRYS_DES.
*    6.    Decrypt the data using CRYS_SST by calling: CRYS_SST_DES.
*    7.    Compare the decrypted result to the original
*    8.      Delete the DES key by calling: SST_DataDelete.
*    9.      Close the authenticator by calling: SST_AuthenticationClose.
*    10.  Delete the authenticator by calling: SST_AuthenticatorDelete.
*    11.  Close the transaction by calling: SST_TransactionClose.
*    12.  Delete the session by calling: SST_SessionDelete.
*                                
*******************************************************************************/   
DxError_t CRYS_SST_TST_ATP_DES ( void );

/*****************************************************************************
* Function Name:                                                           
*  CRYS_SST_TST_ATP_HMAC
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return                                        
*
* Description:                                                                 
*    Test the connection between CRYS and the SSTfunctionality while using SST HMAC generated keys
*    in the CRYS_SST module
*      
* Algorithm:       
*    1.    Create a new session by calling: SST_SessionCreate.
*    2.    Open a transaction by calling: SST_TransactionStart.
*    3.    Generate AES keys inside the SST by calling: CRYS_SST_KG_HMAC.
*    4.    Read the Key from the SST by calling: SST_HMACKeyRead.
*    5.    HASH the data using CRYS and extracted data(key) by calling = CRYS_HMAC.
*    6.    HASH the data using CRYS_SST by calling: CRYS_SST_HMAC.
*    7.    Compare the HASH'd results to they need to be identical
*    8.      Delete the DES key by calling: SST_DataDelete.
*    9.      Close the authenticator by calling: SST_AuthenticationClose.
*    10.  Delete the authenticator by calling: SST_AuthenticatorDelete.
*    11.  Close the transaction by calling: SST_TransactionClose.
*    12.  Delete the session by calling: SST_SessionDelete.
*                                
*******************************************************************************/ 
DxError_t CRYS_SST_TST_ATP_HMAC ( void );



#ifdef __cplusplus
}
#endif

#endif

#endif



